Create or Replace PACKAGE pkg_ALKINDI_RECOMMENDATION
AS
  TYPE RECOMMENDATION_cursor_type IS REF CURSOR;
/*
  PROCEDURE getPredictedRating_old (
    i_user_id    in  USER_ID.user_id%type,
    i_product_id in  PRODUCT.product_id%type,
    o_PR         out number,
    o_error_code out number
  );
*/
  PROCEDURE getPredictedRating (
    i_user_id    in  USER_ID.user_id%type,
    i_product_id in  PRODUCT.product_id%type,
    i_a_prime    in  number,
    o_PR         out number,
    o_error_code out number
  );

  PROCEDURE getPrimaryRecProdsForUser (
    i_user_id            in  USER_ID.user_id%type,
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    i_maxProdsRet        in  number,
    oProdRecStats        out RECOMMENDATION_cursor_type,
    o_error_code         out number
  );

  PROCEDURE getPCRecStats (
    i_user_id    in  USER_ID.user_id%type,
    oEvalStats   out EvalsStat_t,
    oPCRecStats  out RECOMMENDATION_cursor_type,
    o_error_code out number
  );

  PROCEDURE getRecProdsForUser (
    i_user_id            in  USER_ID.user_id%type,
    i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
    i_lowRatingThreshold in  number,
    i_recentRecThreshold in  number,
    i_maxProdsRet        in  number,
    oProdRecStats        out RECOMMENDATION_cursor_type,
    o_error_code         out number
  );

  PROCEDURE sp_INS_Recs(
    i_USER_ID				IN		RECOMMENDATION.USER_ID%TYPE,
    i_PRODUCT_ID			IN		RECOMMENDATION.PRODUCT_ID%TYPE,
    i_PREDICTED_EVALUATION	IN		RECOMMENDATION.PREDICTED_EVALUATION%TYPE,
    i_SCORING_FUNCTION_ID	IN		RECOMMENDATION.SCORING_FUNCTION_ID%TYPE,
    i_PRODUCT_CLUSTER_ID    IN		RECOMMENDATION.PRODUCT_CLUSTER_ID%TYPE
  );

  PROCEDURE sp_Flush_Recommendation_Table(
	i_USER_ID				IN		RECOMMENDATION.USER_ID%TYPE,
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_Flush_Recommendation_Table(
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_PC_NI(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_SCORING_FUNCTION_WEIGHT(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_AVG_EVAL_BY_PROD(
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_AVG_PROD_EVAL			OUT		NUMBER);

  PROCEDURE sp_SEL_ALKINDEX_BY_USER (
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_UC_SUBGROUP_BY_USER (
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

--   PROCEDURE sp_SEL_PROD_BY_PC(
--   	i_USER_ID				  		IN		RECOMMENDATION.USER_ID%TYPE,
--   	i_PRODUCT_CLUSTER_ID		 	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
-- 	i_B6							IN		NUMBER,
-- 	o_RECOMMENDATION_cursor_type   	OUT		RECOMMENDATION_cursor_type,
-- 	o_ERROR_CODE				   	OUT		NUMBER);

END pkg_ALKINDI_RECOMMENDATION;
/

Create or Replace PACKAGE BODY pkg_ALKINDI_RECOMMENDATION
AS

PROCEDURE getPredictedRating (
  i_user_id    in  USER_ID.user_id%type,
  i_product_id in  PRODUCT.product_id%type,
  i_a_prime    in  number default 1,
  o_PR         out number,
  o_error_code out number
) IS
BEGIN
--  dbms_output.enable;
  o_error_code := 0;
  -- If the USER has RATED the PRODUCT, then PR is just that RATING.
  select
    r.evaluation_scale_id
  into
    o_PR
  from
    RATING r
  where
    r.user_id = i_user_id and
    r.product_id = i_product_id;

--  dbms_output.put_line('PR='||to_char(o_PR,'0.999999'));

EXCEPTION
  when no_data_found then
  -- Otherwise, [if the user belongs to at least one UC for the Product's PCs,]
  -- the PR is the weighted average of the UC Ratings for the Product and User
  begin
  -- If at least one member of the UC has rated the Product, the UC Rating is just the average rating
  -- for the members of the UC, and the UC weight is:
  --   Wuc = (# of this product's ratings in the UC)*EXP(A'*bi)
  --   bi comes from the user's Alkindex for PCi
  --   A' is a tunable parameter
  -- Otherwise, the UC Rating is the "filled-in" Rating for the Product, and the UC weight is:
  --   Wuc = 1

    -- [RC] 2001/04/18: fixed
    select
      sum(decode((pus.tot_user_seen * exp(i_a_prime * ast.bi)),0,1,(pus.tot_user_seen * exp(i_a_prime * ast.bi))) * pus.avg_prod_rating_by_uc) /
      sum(decode((pus.tot_user_seen * exp(i_a_prime * ast.bi)),0,1,(pus.tot_user_seen * exp(i_a_prime * ast.bi)))) PR
    into
      o_PR
    from
      UC_SUBGROUP_STAT ast,
      REL_USER_CLUSTER ruc,
      PROD_UC_STAT pus
    where
      ruc.user_id = i_user_id and
      pus.user_cluster_id = ruc.user_cluster_id and
      pus.product_id = i_product_id  and
      ast.user_cluster_id = ruc.user_cluster_id and
      ast.user_cluster_subgroup_index = ruc.user_cluster_subgroup_index;

    -- [RC] 2001/04/18: was:
--    select
--      sum(decode((pus.tot_user_seen * exp(i_a_prime * ast.bi)),0,1,(pus.tot_user_seen * exp(ast.bi))) * pus.avg_prod_rating_by_uc) /
--      sum(decode((pus.tot_user_seen * exp(i_a_prime * ast.bi)),0,1,(pus.tot_user_seen * exp(ast.bi)))) PR
--    into
--      o_PR
--    from
--      PROD_UC_STAT pus,
--      UC_SUBGROUP_STAT ast,
--      REL_PRODUCT_CLUSTER rpc,
--      REL_USER_CLUSTER ruc
--    where
--      rpc.product_id = i_product_id and
--      ruc.user_id = i_user_id and
--      ruc.product_cluster_id = rpc.product_cluster_id and
--      pus.product_cluster_id = rpc.product_cluster_id and
--      pus.product_id = rpc.product_id and
--      ast.user_cluster_id = ruc.user_cluster_id and
--      ast.user_cluster_subgroup_index = ruc.user_cluster_subgroup_index;

      -- [RC] I don't know why this exception is not being catched. This will raise the exception "by hand":
      if o_PR is null then
         raise no_data_found;
      end if;

  exception
    when no_data_found then
    begin
      -- Otherwise, if the user does not belong to a UC for any of the Product's PCs,
      -- the PR is just the average rating for all of the users who rated it
      select
        avg_user_eval
      into
        o_PR
      from
        PROD_STAT
      where
        product_id = i_product_id;
    exception
      when no_data_found then
         o_PR := 3.5;
         o_error_code := 6214; -- PROD_STAT.avg_user_eval is null
    end;
    when others then
	  o_error_code := 6213;
  end;
END getPredictedRating;

-- ==========================================================================================
/*
PROCEDURE getPredictedRating_old (
  i_user_id    in  USER_ID.user_id%type,
  i_product_id in  PRODUCT.product_id%type,
  o_PR         out number,
  o_error_code out number
) IS
  wi number;
  sum_wi number;
  v_avg_prod_rating_by_uc number;
  v_user_cluster_id REL_USER_CLUSTER.user_cluster_id%type;
  v_user_cluster_subgroup_index REL_USER_CLUSTER.user_cluster_subgroup_index%type;
  -- USER_CLUSTERs of a PRODUCT's PRODUCT_CLUSTERs for a USER:
  cursor cUC (p_user_id USER_ID.user_id%type, p_product_id PRODUCT.product_id%type) is
    select
      ruc.user_cluster_id, ruc.user_cluster_subgroup_index
    from
      REL_PRODUCT_CLUSTER rpc,
      REL_USER_CLUSTER ruc
    where
      rpc.product_id = p_product_id and
      ruc.user_id = p_user_id and
      ruc.product_cluster_id = rpc.product_cluster_id;
BEGIN
--  dbms_output.enable;
  o_error_code := 0;
  -- If the USER has RATED the PRODUCT, then PR is just that RATING.
  select
    r.evaluation_scale_id
  into
    o_PR
  from
    RATING r
  where
    r.user_id = i_user_id and
    r.product_id = i_product_id;

--  dbms_output.put_line('PR='||to_char(o_PR,'0.999999'));

exception
  when no_data_found then
  -- Otherwise, does the USER belong to a UC for any of the PRODUCTs PCs?
  begin
    open cUC(i_user_id, i_product_id);
    o_PR := 0;
	sum_wi := 0;
    loop
      fetch cUC into v_user_cluster_id, v_user_cluster_subgroup_index;
      exit when cUC%notfound;
      -- Yes: For each UC that the USER belongs to ...
      begin
  	    select
          (pus.tot_user_seen * exp(ast.bi)) wi,
		  pus.avg_prod_rating_by_uc
        into
          wi,
		  v_avg_prod_rating_by_uc
        from
          PROD_UC_STAT pus,
          UC_SUBGROUP_STAT ast
        where
          pus.product_id = i_product_id and
          pus.user_cluster_id = v_user_cluster_id and
          ast.user_cluster_id = pus.user_cluster_id and
          ast.user_cluster_subgroup_index = v_user_cluster_subgroup_index and
          ast.product_cluster_id = pus.product_cluster_id;
	  exception
	  when no_data_found then
	    wi := 0;
		v_avg_prod_rating_by_uc := 0;
      end;

--      dbms_output.put_line('o_PR := o_PR + (v_tot_user_seen * wi) : o_PR := ' ||
--	                       to_char(o_PR,'990.999999') || ' + (' ||
--						   to_char(v_avg_prod_rating_by_uc) || ' * ' ||
--						   to_char(wi,'990.999999') || ')');

      -- PR = weighted sum of the average UC RATINGs for the PRODUCT
      o_PR := o_PR + (v_avg_prod_rating_by_uc * wi);
      sum_wi := sum_wi + wi;

    end loop;
	if sum_wi != 0 then
	  o_PR := o_PR / sum_wi;
	end if;

    if cUC%rowcount = 0 then
      -- No: PR = average USER RATINGS for the PRODUCT
      select
        avg_user_eval
      into
        o_PR
      from
        PROD_STAT
      where
        product_id = i_product_id;
    end if;
	close cUC;

--    dbms_output.put_line('PR='||to_char(o_PR,'0.999999'));

  exception
    when others then
	  o_error_code := 6213;
      close cUC;
  end;
END getPredictedRating_old;
*/
-- ==========================================================================================

PROCEDURE getPCRecStats (
  i_user_id    in  USER_ID.user_id%type,
  oEvalStats   out EvalsStat_t,
  oPCRecStats  out RECOMMENDATION_cursor_type,
  o_error_code out number
) IS
  v_product_cluster_id PRODUCT_CLUSTER.product_cluster_id%type;
  PCRecStat PCRecStat_t;
  -- USER's PRODUCT_CLUSTERs:
  cursor cPC (p_user_id USER_ID.user_id%type) is
    select
      pc.product_cluster_id
    from
	  PRODUCT_CLUSTER pc;
--      REL_USER_CLUSTER ruc
--    where
--      ruc.user_id = p_user_id;
BEGIN
  o_error_code := 0;
-- -	For each possible evaluation, the number of ratings submitted by the User for Products of any PC
  oEvalStats := EvalsStat_t(null,null,null,null,null,null,null,null,null,null);
  begin
  select
    sum(decode(e.evaluation_scale_id, -4, 1, 0)) nr_minus_4,
    sum(decode(e.evaluation_scale_id, -3, 1, 0)) nr_minus_3,
    sum(decode(e.evaluation_scale_id, -2, 1, 0)) nr_minus_2,
    sum(decode(e.evaluation_scale_id, 0, 1, 0)) nr_0,
    sum(decode(e.evaluation_scale_id, 1, 1, 0)) nr_1,
    sum(decode(e.evaluation_scale_id, 2, 1, 0)) nr_2,
    sum(decode(e.evaluation_scale_id, 3, 1, 0)) nr_3,
    sum(decode(e.evaluation_scale_id, 4, 1, 0)) nr_4,
    sum(decode(e.evaluation_scale_id, 5, 1, 0)) nr_5,
    sum(decode(e.evaluation_scale_id, 6, 1, 0)) nr_6
  into
    oEvalStats.nr_minus_4,
    oEvalStats.nr_minus_3,
    oEvalStats.nr_minus_2,
    oEvalStats.nr_0,
    oEvalStats.nr_1,
    oEvalStats.nr_2,
    oEvalStats.nr_3,
    oEvalStats.nr_4,
    oEvalStats.nr_5,
    oEvalStats.nr_6
  from
    EVALUATION e
  where
    e.user_id = i_user_id;
  exception
  when no_data_found then
     null;
  end;

  open cPC(i_user_id);
  loop
    PCRecStat := PCRecStat_t(null,null,null,null,EvalsStat_t(null,null,null,null,null,null,null,null,null,null));
-- For each PC, the data returned must include:
    fetch cPC into v_product_cluster_id;
    exit when cPC%notfound;
	PCRecStat.product_cluster_id := v_product_cluster_id;

-- -	# Recommendable Products in the PC
    begin
    select
	  count(*)
	into
	  PCRecStat.rec_prods
	from
	  RECOMMENDABLE_PROD_CLUSTER
	where
	  product_cluster_id = v_product_cluster_id;
    exception
    when no_data_found then
	  PCRecStat.rec_prods := 0;
    end;
-- -	Average user rating for products in the PC (USER_PC_STAT.avg_prod_rat)
    begin
    select
	  avg_prod_rat
    into
	  PCRecStat.avg_prod_rat
	from
	  USER_PC_STAT
	where
	  user_id = i_user_id and
	  product_cluster_id = v_product_cluster_id;
    exception
    when no_data_found then
	  PCRecStat.avg_prod_rat := 0;
    end;

-- -	For each possible evaluation (one of {1, 2, 3, 4, 5, 6, 0 -2, -3 -4}), the number of evaluations submitted by the User for Products in the PC
    begin
    select
      sum(decode(e.evaluation_scale_id, -4, 1, 0)) nr_minus_4_PC,
      sum(decode(e.evaluation_scale_id, -3, 1, 0)) nr_minus_3_PC,
      sum(decode(e.evaluation_scale_id, -2, 1, 0)) nr_minus_2_PC,
      sum(decode(e.evaluation_scale_id, 0, 1, 0)) nr_0_PC,
      sum(decode(e.evaluation_scale_id, 1, 1, 0)) nr_1_PC,
      sum(decode(e.evaluation_scale_id, 2, 1, 0)) nr_2_PC,
      sum(decode(e.evaluation_scale_id, 3, 1, 0)) nr_3_PC,
      sum(decode(e.evaluation_scale_id, 4, 1, 0)) nr_4_PC,
      sum(decode(e.evaluation_scale_id, 5, 1, 0)) nr_5_PC,
      sum(decode(e.evaluation_scale_id, 6, 1, 0)) nr_6_PC
    into
	  PCRecStat.evals_stat.nr_minus_4,
	  PCRecStat.evals_stat.nr_minus_3,
	  PCRecStat.evals_stat.nr_minus_2,
	  PCRecStat.evals_stat.nr_0,
	  PCRecStat.evals_stat.nr_1,
	  PCRecStat.evals_stat.nr_2,
	  PCRecStat.evals_stat.nr_3,
	  PCRecStat.evals_stat.nr_4,
	  PCRecStat.evals_stat.nr_5,
	  PCRecStat.evals_stat.nr_6
	from
	  EVALUATION e,
	  REL_PRODUCT_CLUSTER rpc
	where
	  e.user_id = i_user_id and
      rpc.product_id = e.product_id and
	  rpc.product_cluster_id = v_product_cluster_id;
    exception
    when no_data_found then
      null;
    end;

-- -	Is the user in a User Cluster for this PC
    begin
    select
	  decode(count(*), 0,'N','Y') is_in_any_UC_PC
    into
	  PCRecStat.user_is_in_any_UC
	from
	  REL_USER_CLUSTER ruc
	where
	  user_id = i_user_id and
	  product_cluster_id = v_product_cluster_id;
    exception
    when no_data_found then
      null;
    end;

    insert into PCRecStats (
      product_cluster_id,
      rec_prods,
      avg_prod_rat,
      user_is_in_any_uc,
      nr_minus_4,
      nr_minus_3,
      nr_minus_2,
      nr_0,
      nr_1,
      nr_2,
      nr_3,
      nr_4,
      nr_5,
      nr_6
	) values (
	  PCRecStat.product_cluster_id,
      PCRecStat.rec_prods,
      PCRecStat.avg_prod_rat,
      PCRecStat.user_is_in_any_uc,
	  PCRecStat.evals_stat.nr_minus_4,
	  PCRecStat.evals_stat.nr_minus_3,
	  PCRecStat.evals_stat.nr_minus_2,
	  PCRecStat.evals_stat.nr_0,
	  PCRecStat.evals_stat.nr_1,
	  PCRecStat.evals_stat.nr_2,
	  PCRecStat.evals_stat.nr_3,
	  PCRecStat.evals_stat.nr_4,
	  PCRecStat.evals_stat.nr_5,
	  PCRecStat.evals_stat.nr_6
	);
  end loop;
  close cPC;
  PCRecStat := null;

  open oPCRecStats for
  select
    product_cluster_id,
    rec_prods,
    avg_prod_rat,
    user_is_in_any_uc,
    nr_minus_4,
    nr_minus_3,
    nr_minus_2,
    nr_0,
    nr_1,
    nr_2,
    nr_3,
    nr_4,
    nr_5,
    nr_6
  from
    PCRecStats;

exception
  when others then
  o_error_code := 6215;
  close cPC;
END getPCRecStats;

-- ==========================================================================================

PROCEDURE getPrimaryRecProdsForUser (
  i_user_id            in  USER_ID.user_id%type,
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  i_maxProdsRet        in  number,
  oProdRecStats        out RECOMMENDATION_cursor_type,
  o_error_code         out number
) IS
  ProdRecStat ProdRecStat_t;

  v_product_id PRODUCT.product_id%type;
  -- USER_CLUSTERs of a PRODUCT's PRODUCT_CLUSTERs for a USER:
  cursor cProduct (
    p_user_id USER_ID.user_id%type,
    p_product_cluster_id PRODUCT_CLUSTER.product_cluster_id%type
  ) is
    select
      rpc.product_id
    from
      RECOMMENDABLE_PROD_CLUSTER rpc
    where
      rpc.product_cluster_id = p_product_cluster_id and
      not exists (
	    select 'x'
		from
		  EVALUATION e
		where
		  e.product_id = rpc.product_id and
		  e.user_id = p_user_id
      ) and
      not exists (
	    select 'x'
		from
		  RECOMMENDATION r
		where
		  r.product_id = rpc.product_id and
		  r.user_id = p_user_id
      );
BEGIN
  o_error_code := 0;

  open cProduct(i_user_id, i_product_cluster_id);
  loop
-- For each Product, the data returned must include:
    fetch cProduct into v_product_id;
    exit when cProduct%notfound;
    ProdRecStat := ProdRecStat_t(null,null,null,null,null,null,null,null,null,null,null,null,null,null);
    ProdRecStat.product_id := v_product_id;

--	If the User belongs to a User Cluster for the given Product Cluster,
--     the Product's average rating within the UC
--	Scoring Function value
    begin
      select
        pus.avg_prod_rating_by_uc,
        pus.score1,
        pus.score2,
        pus.score3,
        pus.score4,
        pus.score5,
        pus.score6,
        pus.score7,
        pus.score8
      into
        ProdRecStat.avg_rat_uc,
        ProdRecStat.SF1,
        ProdRecStat.SF2,
        ProdRecStat.SF3,
        ProdRecStat.SF4,
        ProdRecStat.SF5,
        ProdRecStat.SF6,
        ProdRecStat.SF7,
        ProdRecStat.SF8
      from
        REL_USER_CLUSTER ruc,
        PROD_UC_STAT pus
      where
        ruc.user_id = i_user_id and
        ruc.product_cluster_id = i_product_cluster_id and
        pus.product_id = v_product_id and
        pus.user_cluster_id = ruc.user_cluster_id;
    exception
      when no_data_found then
        null;
    end;

    begin
      select
        ps.avg_user_eval
      into
        ProdRecStat.avg_rat
      from
        PROD_STAT ps
      where
        ps.product_id = v_product_id;
    exception
      when no_data_found then
        ProdRecStat.avg_rat := null;
    end;

    ProdRecStat.prod_eval := -1;
    ProdRecStat.timestamp_eval := null;
    ProdRecStat.PR := 0;

    insert into ProdRecStats (
      product_id,
      avg_rat_uc,
      sf1,
      sf2,
      sf3,
      sf4,
      sf5,
      sf6,
      sf7,
      sf8,
      prod_eval,
      timestamp_eval,
      pr,
      avg_rat
    ) values (
      ProdRecStat.product_id,
      ProdRecStat.avg_rat_uc,
      ProdRecStat.sf1,
      ProdRecStat.sf2,
      ProdRecStat.sf3,
      ProdRecStat.sf4,
      ProdRecStat.sf5,
      ProdRecStat.sf6,
      ProdRecStat.sf7,
      ProdRecStat.sf8,
      ProdRecStat.prod_eval,
      ProdRecStat.timestamp_eval,
      ProdRecStat.pr,
      ProdRecStat.avg_rat
    );

  end loop;
  close cProduct;
  ProdRecStat := null;

  open oProdRecStats for
  select
    product_id,
    avg_rat_uc,
    sf1,
    sf2,
    sf3,
    sf4,
    sf5,
    sf6,
    sf7,
    sf8,
    prod_eval,
    timestamp_eval,
    pr,
    avg_rat
  from
    ProdRecStats
  where
    rownum <= i_maxProdsRet;

exception
  when others then
    o_error_code := 6216;
    close cProduct;
END getPrimaryRecProdsForUser;

-- ==========================================================================================

PROCEDURE getRecProdsForUser (
  i_user_id            in  USER_ID.user_id%type,
  i_product_cluster_id in  PRODUCT_CLUSTER.product_cluster_id%type,
  i_lowRatingThreshold in  number,
  i_recentRecThreshold in  number,
  i_maxProdsRet        in  number,
  oProdRecStats        out RECOMMENDATION_cursor_type,
  o_error_code         out number
) IS
  ProdRecStat ProdRecStat_t;

  v_discardProduct boolean;
  v_product_id PRODUCT.product_id%type;
  v_recommendation_timestamp RECOMMENDATION.recommendation_timestamp%type;
  v_recentRecDateThreshold date;
  -- USER_CLUSTERs of a PRODUCT's PRODUCT_CLUSTERs for a USER:
  cursor cProduct (
    p_user_id USER_ID.user_id%type,
    p_product_cluster_id PRODUCT_CLUSTER.product_cluster_id%type,
	p_lowRatingThreshold number
  ) is
    select
      rpc.product_id
    from
      RECOMMENDABLE_PROD_CLUSTER rpc
    where
      rpc.product_cluster_id = p_product_cluster_id and
      not exists (
	    select 'x'
		from
		  EVALUATION e
		where
		  e.product_id = rpc.product_id and
		  e.user_id = p_user_id and
		  (e.evaluation_scale_id = -3 or
		   (e.evaluation_scale_id > 0 and
		    e.evaluation_scale_id < p_lowRatingThreshold
		   )
		  )
      );

BEGIN
  o_error_code := 0;
  v_recentRecDateThreshold := sysdate - i_recentRecThreshold;

  open cProduct(i_user_id, i_product_cluster_id, i_lowRatingThreshold);
  loop
-- For each Product, the data returned must include:
    fetch cProduct into v_product_id;
    exit when cProduct%notfound;
    begin
      v_discardProduct := FALSE;
  	  select
  	    recommendation_timestamp
      into
        v_recommendation_timestamp
  	  from
  	    RECOMMENDATION
  	  where
  	    user_id = i_user_id and
  	    product_id = v_product_id;

      if v_recommendation_timestamp >= v_recentRecDateThreshold then
        v_discardProduct := TRUE;
	  end if;
    exception
    when no_data_found then
      null;
    end;
	if (v_discardProduct = FALSE) then
      ProdRecStat := ProdRecStat_t(null,null,null,null,null,null,null,null,null,null,null,null,null,null);
	  ProdRecStat.product_id := v_product_id;

--	If the User belongs to a User Cluster for the given Product Cluster,
--     the Product's average rating within the UC
--	Scoring Function value
      begin
        select
	      pus.avg_prod_rating_by_uc,
		  pus.score1,
		  pus.score2,
		  pus.score3,
		  pus.score4,
		  pus.score5,
		  pus.score6,
		  pus.score7,
		  pus.score8
	    into
	      ProdRecStat.avg_rat_uc,
	      ProdRecStat.SF1,
	      ProdRecStat.SF2,
	      ProdRecStat.SF3,
	      ProdRecStat.SF4,
	      ProdRecStat.SF5,
	      ProdRecStat.SF6,
	      ProdRecStat.SF7,
	      ProdRecStat.SF8
	    from
		  REL_USER_CLUSTER ruc,
          PROD_UC_STAT pus
	    where
		  ruc.user_id = i_user_id and
		  ruc.product_cluster_id = i_product_cluster_id and
	      pus.product_id = v_product_id and
		  pus.user_cluster_id = ruc.user_cluster_id;
      exception
	  when no_data_found then
        null;
	  end;

      begin
        select
          ps.avg_user_eval
        into
          ProdRecStat.avg_rat
        from
          PROD_STAT ps
        where
          ps.product_id = v_product_id;
      exception
        when no_data_found then
          ProdRecStat.avg_rat := null;
      end;

--	The User's evaluation for the Product; if none exists, then -1
--	The timestamp of the User's rating for the Product, if any (null OK)
      begin
        select
	      evaluation_scale_id,
		  evaluation_timestamp
	    into
	      ProdRecStat.prod_eval,
	      ProdRecStat.timestamp_eval
	    from
          EVALUATION
	    where
	      user_id = i_user_id and
	      product_id = v_product_id;
      exception
	  when no_data_found then
	    ProdRecStat.prod_eval := -1;
	    ProdRecStat.timestamp_eval := null;
	  end;

--	The Predicted Rating for the Product
--      getPredictedRating(i_user_id, v_product_id, ProdRecStat.PR, o_error_code);

--      getPredictedRating(i_user_id, v_product_id, killme, o_error_code);
--	  if o_error_code != 0 then
--        exit;
--	  end if;
--      ProdRecStat.PR := killme;

-- Returning Predicted Rating = 0 temporarily,
-- to change back just comment the following line and uncomment the lines above
      ProdRecStat.PR := 0;

	  insert into ProdRecStats (
        product_id,
        avg_rat_uc,
        sf1,
        sf2,
        sf3,
        sf4,
        sf5,
        sf6,
        sf7,
        sf8,
        prod_eval,
        timestamp_eval,
        pr,
        avg_rat
	  ) values (
	    ProdRecStat.product_id,
        ProdRecStat.avg_rat_uc,
        ProdRecStat.sf1,
        ProdRecStat.sf2,
        ProdRecStat.sf3,
        ProdRecStat.sf4,
        ProdRecStat.sf5,
        ProdRecStat.sf6,
        ProdRecStat.sf7,
        ProdRecStat.sf8,
        ProdRecStat.prod_eval,
        ProdRecStat.timestamp_eval,
        ProdRecStat.pr,
        ProdRecStat.avg_rat
	  );

	end if;
  end loop;
  close cProduct;
  ProdRecStat := null;

  open oProdRecStats for
  select
    product_id,
    avg_rat_uc,
    sf1,
    sf2,
    sf3,
    sf4,
    sf5,
    sf6,
    sf7,
    sf8,
    prod_eval,
    timestamp_eval,
    pr,
    avg_rat
  from
    ProdRecStats
  where
    rownum <= i_maxProdsRet;

exception
  when others then
    o_error_code := 6216;
    close cProduct;
END getRecProdsForUser;

-- ==========================================================================================

-- BK092400 - Used by Recommendation Manager
-- Search user's product cluster statistics by selecting product_cluster_id, total_prod_seen and avg_prod_rat values
-- from USER_PC_STAT

PROCEDURE sp_INS_Recs(
   i_USER_ID				IN	RECOMMENDATION.USER_ID%TYPE,
   i_PRODUCT_ID				IN	RECOMMENDATION.PRODUCT_ID%TYPE,
   i_PREDICTED_EVALUATION	IN	RECOMMENDATION.PREDICTED_EVALUATION%TYPE,
   i_SCORING_FUNCTION_ID	IN	RECOMMENDATION.SCORING_FUNCTION_ID%TYPE,
   i_PRODUCT_CLUSTER_ID     IN	RECOMMENDATION.PRODUCT_CLUSTER_ID%TYPE
)
IS BEGIN

   INSERT INTO RECOMMENDATION (
	  USER_ID,
	  PRODUCT_ID,
	  PREDICTED_EVALUATION,
	  SCORING_FUNCTION_ID,
	  RECOMMENDATION_TIMESTAMP,
      PRODUCT_CLUSTER_ID
   ) VALUES (
	  i_USER_ID,
	  i_PRODUCT_ID,
	  i_PREDICTED_EVALUATION,
	  i_SCORING_FUNCTION_ID,
	  sysdate,
	  i_PRODUCT_CLUSTER_ID
   );

EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
   INSERT INTO RECOMMENDATION_LOG (
   	  USER_ID,
	  PRODUCT_ID,
	  PREDICTED_EVALUATION,
	  SCORING_FUNCTION_ID,
	  RECOMMENDATION_TIMESTAMP,
	  LOG_TIMESTAMP,
      PRODUCT_CLUSTER_ID
   ) (
   SELECT
   	  USER_ID,
	  PRODUCT_ID,
	  PREDICTED_EVALUATION,
	  SCORING_FUNCTION_ID,
	  RECOMMENDATION_TIMESTAMP,
	  sysdate,
      PRODUCT_CLUSTER_ID
   FROM
      RECOMMENDATION
   WHERE
      USER_ID = i_USER_ID AND
	  PRODUCT_ID = i_USER_ID
   );

   UPDATE RECOMMENDATION SET
	  PREDICTED_EVALUATION = i_PREDICTED_EVALUATION,
	  SCORING_FUNCTION_ID = i_SCORING_FUNCTION_ID,
	  RECOMMENDATION_TIMESTAMP = sysdate,
      PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
   WHERE
      USER_ID = i_USER_ID AND
	  PRODUCT_ID = i_PRODUCT_ID;

 END sp_INS_Recs;

-- ==========================================================================================
-- Flushing the recommendation table by first inserting records into the RECOMMENDATION_LOG and then deleting
-- the old/existing records, given a supplied user_id and date

  PROCEDURE sp_Flush_Recommendation_Table(
	i_USER_ID				IN		RECOMMENDATION.USER_ID%TYPE,
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;

	INSERT
	  INTO RECOMMENDATION_LOG (USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, LOG_TIMESTAMP, PRODUCT_CLUSTER_ID)
     (SELECT USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, sysdate, PRODUCT_CLUSTER_ID
	  FROM RECOMMENDATION
	 WHERE USER_ID = i_USER_ID
	   AND RECOMMENDATION_TIMESTAMP < i_DATE);

	DELETE
	  FROM RECOMMENDATION
	 WHERE USER_ID = i_USER_ID
	   AND RECOMMENDATION_TIMESTAMP < i_DATE;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6401;


  END sp_Flush_Recommendation_Table;
-- ==========================================================================================
-- Flushing the recommendationt table by only passing in the date but no user_id, and then delete the old records

  PROCEDURE sp_Flush_Recommendation_Table(
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;

	INSERT
	  INTO RECOMMENDATION_LOG (USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, LOG_TIMESTAMP, PRODUCT_CLUSTER_ID)
     (SELECT USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, sysdate, PRODUCT_CLUSTER_ID
	   FROM RECOMMENDATION
	  WHERE RECOMMENDATION_TIMESTAMP < i_DATE);

	DELETE
	  FROM RECOMMENDATION
	 WHERE RECOMMENDATION_TIMESTAMP < i_DATE;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6402;


  END sp_Flush_Recommendation_Table;

-- ==========================================================================================

  PROCEDURE sp_SEL_PC_NI(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT
	   Product_Cluster_Id,
	   Wgt_Tot_Prod_In_PC NI
	FROM
	   PC_STAT
	ORDER BY
	   Product_Cluster_Id;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := 6211;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_PC_NI;

-- ==========================================================================================

-- selecting all scoring function ids and their weight without passing in any values

  PROCEDURE sp_SEL_SCORING_FUNCTION_WEIGHT(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN

	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT SCORING_FUNCTION_ID, SCORING_FUNCTION_WEIGHT
	  FROM SCORING_FUNCTION;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := 6405;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_SCORING_FUNCTION_WEIGHT;

-- ==========================================================================================

-- selecting the average evaluations of a specified product

  PROCEDURE sp_SEL_AVG_EVAL_BY_PROD(
	i_PRODUCT_ID		IN		EVALUATION.PRODUCT_ID%TYPE,
	o_AVG_PROD_EVAL		OUT		NUMBER)
   IS BEGIN

	SELECT AVG_USER_EVAL INTO o_AVG_PROD_EVAL
	  FROM PROD_STAT
	 WHERE PRODUCT_ID = i_PRODUCT_ID;

   END sp_SEL_AVG_EVAL_BY_PROD;

-- ==========================================================================================

  PROCEDURE sp_SEL_ALKINDEX_BY_USER (
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
    sp_SEL_UC_SUBGROUP_BY_USER(i_USER_ID, o_RECOMMENDATION_cursor_type, o_ERROR_CODE);
  END sp_SEL_ALKINDEX_BY_USER;

-- ==========================================================================================

PROCEDURE sp_SEL_UC_SUBGROUP_BY_USER (
  i_USER_ID				IN		USER_ID.USER_ID%TYPE,
  o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
  o_ERROR_CODE			OUT		NUMBER
) IS
BEGIN
  o_ERROR_CODE := 0;

  OPEN o_RECOMMENDATION_cursor_type FOR
  SELECT
    S.PRODUCT_CLUSTER_ID,
    S.NI,
    UPCS.tot_prod_seen AS FI,
    S.BBI,
    S.BI
  FROM
    UC_SUBGROUP_STAT S,
    USER_PC_STAT UPCS,
    REL_USER_CLUSTER R
  WHERE
    R.USER_ID = i_USER_ID AND
    S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID AND
    S.USER_CLUSTER_SUBGROUP_INDEX = R.USER_CLUSTER_SUBGROUP_INDEX AND
    R.USER_CLUSTER_ID = S.USER_CLUSTER_ID AND
    UPCS.product_cluster_id = S.product_cluster_id AND
    UPCS.user_id = R.USER_ID
  ;

-- [RC] 2001/05/09: was

--  SELECT
--    S.PRODUCT_CLUSTER_ID,
--    S.NI,
--    COUNT(E.EVALUATION_SCALE_ID) AS FI,
--    S.BBI,
--    S.BI
--  FROM
--    UC_SUBGROUP_STAT S,
--    EVALUATION E,
--    REL_USER_CLUSTER R
--  WHERE
--    S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID AND
--    S.USER_CLUSTER_SUBGROUP_INDEX = R.USER_CLUSTER_SUBGROUP_INDEX AND
--    R.USER_CLUSTER_ID = S.USER_CLUSTER_ID AND
--    E.USER_ID = i_USER_ID AND
--    R.USER_ID = E.USER_ID
--  GROUP BY
--    S.PRODUCT_CLUSTER_ID,
--    S.NI,
--    S.BBI,
--    S.BI
--  ;

EXCEPTION
  WHEN OTHERS THEN
    o_ERROR_CODE  := 6408;
    CLOSE o_RECOMMENDATION_cursor_type;
END sp_SEL_UC_SUBGROUP_BY_USER;

-- ==========================================================================================
--  PROCEDURE sp_SEL_PROD_BY_PC(
--    i_USER_ID				  	 IN			RECOMMENDATION.USER_ID%TYPE,
--  	i_PRODUCT_CLUSTER_ID		 IN			PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
--	i_B6						 IN			NUMBER,
--	o_RECOMMENDATION_cursor_type OUT		RECOMMENDATION_cursor_type,
--	o_ERROR_CODE				 OUT		NUMBER)
--  IS BEGIN

	 /*
	 This is for users who do not belong to a UserCluster for the ProductCluster from which
	 we wish to recommend.

	 The query selects Products based on their aggregate score of weighted sums of evaluations, which is
	 Score4 in PROD_UC_STAT. It also checks that no Rating or Recommendation exists for the
	 Products and user.
	 */
--   	 o_ERROR_CODE := 0;
-- 	 OPEN o_RECOMMENDATION_cursor_type FOR
-- 	 SELECT PRODUCT_ID, PRODUCT_TYPE_ID FROM (
-- 		 SELECT
-- 		 	   PRODUCT_ID, PRODUCT_TYPE_ID, sum(SCORE4) AS SCORE4SUM, sum(S.AVG_PROD_RATING_BY_UC)/count(*) as AVG_EVAL
-- 		 FROM
-- 		       PROD_UC_STAT S
-- 		 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID	AND
-- 	   	   	not exists (SELECT /*+ index(E UN_EVALUATION_1) */ 'x'
-- 	                    FROM EVALUATION E
-- 	     			     WHERE E.Product_Id = S.Product_Id AND
-- 	     			         E.User_Id=i_User_Id AND
-- 	     					 E.Evaluation_Scale_Id > 0
-- 	                   ) AND
-- 	        not exists (SELECT 'x'
-- 	                    FROM RECOMMENDATION R
-- 	     			     WHERE R.Product_Id = S.Product_Id AND
-- 	     			           R.User_Id=i_User_Id
-- 	                   )
-- 		 GROUP BY PRODUCT_ID )
-- 	WHERE AVG_EVAL > i_B6
--   ORDER BY SCORE4SUM DESC;
--   EXCEPTION
-- 	WHEN OTHERS THEN
--       o_ERROR_CODE  := 6415;
--       CLOSE o_RECOMMENDATION_cursor_type;
--   END  sp_SEL_PROD_BY_PC;

END pkg_ALKINDI_RECOMMENDATION;
/
